#include <avr/io.h>
#include <avr/interrupt.h>
#include <string.h>

#include "pff.h"
#include "diskio.h"
#include "integer.h"

//------------------------------------------------------------------
char read_buf[128]={};
char write_buf[128]={'w','r','i','t','e',' ','o','k','\r','\n',0x00};

//------------------------------------------------------------------
void uart_init(void)
{
UBRRH = 0x00;					//Set 256000 bit per second
UBRRL = 0x01;

UCSRA = 0x00;
UCSRB = (1<<RXEN)|(1<<TXEN);	//Receive and transmit enable
UCSRC = (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0);	
}

void uart_transmit(char data )	//transmit byte by UART
{

while ( !( UCSRA & (1<<UDRE)) )
; 
UDR = data;
}

void uart_transmit_message(char* msg)	//transmit message by UART
{ unsigned char i;
  i=0;

  while ((i<256)&(msg[i]!=0x00) )
   {
    uart_transmit(msg[i]);
    i++;
   }
}
//------------------------------------------------------------------
FRESULT scan_files (char* path)			//Scan directore function
{
 FRESULT res;
 FILINFO fno;
 DIR dir;

    res = pf_opendir(&dir, path);		//open dir
    if (res == FR_OK) {
                       for (;;) 
					    {
                         res = pf_readdir(&dir, &fno);		//read dir
                         if (res != FR_OK || fno.fname[0] == 0) break;
                         if (fno.fattrib & AM_DIR) {		//if object is a DIR
                                                    uart_transmit_message("DIR: ");
                                                    uart_transmit_message(fno.fname);
                                                    uart_transmit_message("\r\n");
                                                   }
										      else {		//if object is a file
                                                    uart_transmit_message("FILE: ");
                                                    uart_transmit_message(fno.fname);
                                                    uart_transmit_message("\r\n");                                 
                                                   }
                       }
                      }
    return res;
}
//------------------------------------------------------------------
int main ()
{
 FATFS fs;				//FatFs object
 FRESULT res;			//result
 WORD s1;

 uart_init(); 			//Init UART
 
 res=pf_mount(&fs);		//mount FAT
 uart_transmit_message("mounting FAT ");
  if (res==0x00) {		//if FAT mount succes
                  	uart_transmit_message("OK\r\n");

 					res=pf_open("/read.txt");			//open read txt
 					uart_transmit_message("open read.txt ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
           					 else uart_transmit_message("FAIL\r\n");
 					res=pf_lseek (0);					//set to 0 pointer in read.txt
 					uart_transmit_message("set 0 to pointer into read.txt ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
  					          else uart_transmit_message("FAIL\r\n");
					res = pf_read(read_buf, 128, &s1);	//read first 128 bytes from read.txt
 					uart_transmit_message("read first 128 bytes from read.txt ");
 					 if (res==0x00) uart_transmit_message("OK\r\n");
           					 else uart_transmit_message("FAIL\r\n");
					uart_transmit_message("data in read.txt:\r\n");
 					uart_transmit_message(read_buf);	//transmit first 128 bytes from read.txt

 					res=pf_open("/write.txt");
 					uart_transmit_message("open write.txt ");	//open write.txt
  					if (res==0x00) uart_transmit_message("OK\r\n");
            					else uart_transmit_message("FAIL\r\n"); 					
 					res=pf_write(write_buf,strlen(write_buf),&s1);	//write to write.txt
 					uart_transmit_message("writing @write ok@ in write.txt ");
  					if ((res==0x00)&&(s1==strlen(write_buf))) uart_transmit_message("OK\r\n");
                        			                 	else uart_transmit_message("FAIL\r\n");
 					res=pf_write(0,0,&s1);							//finalizing write into write.txt
 					uart_transmit_message("finalizing write.txt ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
            					else uart_transmit_message("FAIL\r\n");

 					res=pf_lseek (0);								//set to 0 pointer into write.txt
 					uart_transmit_message("set 0 to pointer into write.txt ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
            					else uart_transmit_message("FAIL\r\n");
                    read_buf[0]=0;									//clear buff
 					res = pf_read(read_buf, 128, &s1);				//read first 128 bytes from write.txt
 					uart_transmit_message("read first 128 bytes from write.txt ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
            					else uart_transmit_message("FAIL\r\n");
 					uart_transmit_message("data in write.txt:\r\n");	
 					uart_transmit_message(read_buf);				//transmit first 128 bytes from write.txt

 					uart_transmit_message("scaning test_dir:\r\n");
 					scan_files ("test_dir");						//scan test dir
 					uart_transmit_message("scaning ended\r\n");

					res=pf_mount(0x00);								//unmount FatFs
 					uart_transmit_message("unmounting FAT ");
  					if (res==0x00) uart_transmit_message("OK\r\n");
            					else uart_transmit_message("FAIL\r\n");
 				  }
               else uart_transmit_message("FAIL\r\n");
  while (1)
   ;
}
